//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "PWMUseCase.h"

@implementation PWMUseCase: NSObject

NSMutableArray * pwmConfigurationList;
NSData         * response1;
NSData         * response2;
NSData         * response3;

#pragma mark - sharedInstance
+ (PWMUseCase *) sharedInstance
{
    static PWMUseCase *sharedInstance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{ sharedInstance = [[PWMUseCase alloc] init]; });
    return sharedInstance;
}

#pragma mark - readPWM
- (void) readPWM:(void (^)(NSData *aData, const int order))success  onFailure : (void(^)(NSError *error))failure{
    
    // Read GPIO/PWM Configuration
    ISO15693Command *readGPIOPWMConfig = [[ISO15693Command alloc] initWithData:cmd_readGPIOPWMConfig];
    
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: readGPIOPWMConfig onSuccess:^(NSData *aData){
        success(aData, 0);   // 00 03 00 00 00 33 00 39 00
    } onFailure:^(NSError *error) {
        NSLog(@"readPWM error :\n%@", error.localizedDescription);
    }];
    
    // Read PWM0 Register
    ISO15693Command *readPWM0Reg = [[ISO15693Command alloc] initWithData:cmd_readPWM0Reg];
    
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: readPWM0Reg onSuccess:^(NSData *aData){
        success(aData, 1);  // 00 33 00 39 00 19 00 39 00
    } onFailure:^(NSError *error) {
        NSLog(@"readPWM error :\n%@", error.localizedDescription);
    }];
    
    // Read PWM1 Register
    ISO15693Command *readPWM1Reg = [[ISO15693Command alloc] initWithData:cmd_readPWM1Reg];
    
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: readPWM1Reg onSuccess:^(NSData *aData){
        success(aData,2);  // 00 19 00 39 00 00 00 00 00
        [[NTAG5_NFC_LIB sharedInstance] setMessage:str_tag_correctly_read];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {} onFailure:^(NSError *error) {
            NSLog(@"readPWM error :\n%@", error.localizedDescription);
        }];
    } onFailure:^(NSError *error) {
        NSLog(@"readPWM error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - writePWM
- (void) writePWM: (ISO15693Command *) pwmConfig pwm0Command: (ISO15693Command *) pwm0Command pwm1Command: (ISO15693Command *) pwm1Command onSuccess:(void (^)(NSData *aData))success  onFailure : (void(^)(NSError *error))failure{
    
    // Write GPIO/PWM Configuration
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: pwmConfig onSuccess:^(NSData *aData){
        
    } onFailure:^(NSError *error) {
        NSLog(@"writePWM error :\n%@", error.localizedDescription);
    }];
    
    // Write to PWM1 Register
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: pwm0Command onSuccess:^(NSData *aData){
        
    } onFailure:^(NSError *error) {
        NSLog(@"writePWM error :\n%@", error.localizedDescription);
    }];
    
    // Write to PWM0 Register
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: pwm1Command onSuccess:^(NSData *aData){
        success(aData);
        [[NTAG5_NFC_LIB sharedInstance] setMessage:@"Tag correctly written!"];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    } onFailure:^(NSError *error) {
        NSLog(@"writePWM error :\n%@", error.localizedDescription);
    }];
}

@end
